package de.bebagoe.matrain.stats;

import java.util.*;

public class DataMat {
	public double[][] data;
	private int az = 1, as = 1;
	final private int maxSize = 1_310_720; // Die Array-Größe wird beschränkt auf 10 MB.

	public DataMat(int z, int s) {
		if (z >= 1  &&  s >= 1  &&  z * s  <= maxSize) {
			az = z;
			as = s;
		} else {
			IO.println("\nWegen Zeilen < 1, Spalten < 1 oder Speicherbedarf > " + maxSize +
					" wurde Zeilen = Spalten = 1 gesetzt");
		}
		data = new double[az][as];
	}

	public int anz() {return data.length;}

	public int ans() {return data[0].length;}
		
	public void show() {
		for (int i = 0; i < az; i++) {
			for (int j = 0; j < as; j++)
				System.out.printf("%8.2f ", data[i][j]);
			IO.println();
			}
		IO.println();
	}

	public void flip() {
		if (az == as) {
			double buffer;
			for (int i = 0; i < az; i++)
				for (int j = 0; j < i; j++) {
					buffer = data[i][j];
					data[i][j] = data[j][i];
					data[j][i] = buffer;
				}
		} else {
			int temp = az;
			az = as;
			as = temp;
			double ndata[][] = new double[az][as];
			for (int i = 0; i < az; i++)
				for (int j = 0; j < as; j++)
					ndata[i][j] = data[j][i];
			data = ndata;
		}
	}

	public double[] mean() { 
		double sum[] = new double[as];
		for (int j = 0; j < as; j++ ) {
			for (int i = 0; i < az; i++)
				sum[j] += data[i][j];
			sum[j] /= az;
		}
		return sum;
	} 

	public double[] variance() { 
		double sum[] = new double[as];
		double qs[] = new double[as];
		for (int j = 0; j < as; j++ ) {
			for (int i = 0; i < az; i++) {
				sum[j] += data[i][j];
				qs[j] += data[i][j] * data[i][j];
			}
			qs[j] = (qs[j] - (sum[j]*sum[j]/az)) / (az-1);
		}
		return qs;
	}	

	public NavigableMap<Double, Long> frequencies(int s) {
		if (s < 0 || s >= as)
			return null;
		NavigableMap<Double, Long> ft = new TreeMap<>();
		for (int i = 0; i < az; i++)
			if (ft.containsKey(data[i][s])) {
				long temp = ft.get(data[i][s]);
				ft.put(data[i][s], ++temp); // Potenzielles Performanzproblem durch Autoboxing!
			} else
				ft.put(data[i][s], 1L);
		return ft;
	}
}